//button_demo.c
library "PToolboxLib"
include "Fctl.h"

//Setup ID numbers (easier to manage for large projects)
#define FORM1 3000
#define BUTTON1 3001
#define BUTTON2 3002
#define BUTTON3 3003
#define BUTTON4 3004
#define BUTTON5 3005
#define BUTTON6 3006
#define BUTTON7 3007
#define BUTTON8 3008
#define BUTTON9 3009
#define BUTTON10 3010
#define BUTTON11 3011
#define BUTTON12 3012
#define BUTTON13 3013
#define BUTTON14 3014

#define LIST1 3020
#define LIST2 3021
#define LIST3 3022
#define LIST4 3023

#define FIELD1 3030
#define FIELD2 3031
#define FIELD3 3033

#define DIALOG1 4000
#define BUTTON15 4001

main() {
int e,i,pos;
string numbers[7] = {"1","2","5","10","20","50","100"};
string names[7] = {"first","second","third","fourth","fifth","sixth","seventh"};
string games[8] = {"tennis","`f01football","baseball","`f03\x16`fFF basketball","cricket","golf","hockey","volleyball"};

clear();
Sony(1,1); //enable Sony Hi-Res if avail
Form(FORM1,"Button Form");
Fctl(SETMENU,10000);
//first field is button ID
//buttons
Button(BUTTON1,0x4,120,60,0,0,"SELECT");
Button(BUTTON2,0x10,120,20,0,0,"EXIT");
Button(BUTTON3,0x20,120,40,0,0,"SHOW");
Button(BUTTON14,0x00,120,80,0,0,"NULL");
Button(BUTTON4,0x30,120,100,0,0,"DIALOG");


//a stand-alone push button
pos = Button(BUTTON5,0x001,10,37,0,0,"HIM");

//group 1 pushbuttons
pos = Button(BUTTON6,0x101,pos,37,0,0,"HER");
Button(BUTTON7,0x101,pos,37,0,0,"IT");

//group 2 checkboxes
Button(BUTTON8,0x202,10,91,0,0,"THIS");
Button(BUTTON9,0x202,10,109,0,0,"THAT");
Button(BUTTON10,0x202,10,127,0,0,"THOSE");

//a stand alone checkbox
Button(BUTTON11,0x002,10,145,0,0,"THING");

//two fields (non-editable, no underline)
Field(FIELD1,0x110,80,120,80,16,64,"ID");
Field(FIELD2,0x110,80,140,80,16,64,"NAME");

//Setup Combo Box (poptrigger with list)
List(LIST1,60,20,40,5,BUTTON12);
FsetList(LIST1,1,7,names);
Button(BUTTON12,0x003,60,20,0,0,"Trig");
Fctl(INCSEARCH,LIST1); //enable incremental search

//a drop-down list1 used by BUTTON1
List(LIST2,120,60,40,7,9999);
FsetList(LIST2,0,7,numbers);

//Setup Combo Field (field with pop-up list)
Field(FIELD3,0x1001,20,20,20,12,4,numbers[0]); //field needs to go before trigger button
Button(BUTTON13,0x003,5,20,11,0,"");
List(LIST3,5,20,40,7,BUTTON13);
FsetList(LIST3,0,7,numbers);

//a stand-alone list
List(LIST4,52,60,60,4,0);
FsetList(LIST4,-1,8,games);
Fctl(LISTHAND,LIST4);

Fctl(HIDEALL); //hide all object
Fctl(DRAW,FORM1); //draw objects
Fctl(SHOW,BUTTON2); //show button
Fctl(SHOW,BUTTON3); //show button 

FsetState(BUTTON9,1);
FsetState(BUTTON5,1);

//hooksilk(1);

while(1) {
	e=Fevent(1);
		
	//show ID & text of button pressed
	if(e>240 && Fctl(EXIST,FIELD1)) {
      FsetText(FIELD1,"ID="+e);
      if(e>255) FsetText(FIELD2,"NAME="+FgetText(e));
    }
    
    
	switch(e) {
	case 5: //page up hardkey
	  Fctl(204,LIST4);
	  break;
	case 6: //page down hardkey
	  Fctl(205,LIST4);
	  break;
	case BUTTON1:
	  i=Fctl(POPLIST,LIST2); //pop the misc list
	  if(i>=0) FsetText(BUTTON1,FgetText(LIST2));
	  break;
	case BUTTON2:
	  return;
	case BUTTON3:
	  Fctl(SHOWALL);
	  Fctl(SHOW,LIST4); //stand-alone list
	  break; 
	case BUTTON4:
	  //pop a dialog
	  Dialog(DIALOG1,10,10,140,140,"Dialog!");
	  Fctl(FRAME,0x0205);
      Button(BUTTON15,0,30,30,0,0,"Done");
      Fctl(DRAW,DIALOG1);        
	  break;
	case BUTTON13:
	  FsetText(FIELD3,FgetText(LIST3));
	  break;
	case BUTTON15:
	  Fctl(FREE,DIALOG1); //delete dialog
	  break;
	}
}
}

